
## Setup

1. Install dependencies:
```bash
pip install openai numpy
pip install validate  # For plan validation
```

2. Set OpenAI API key:
```bash
export OPENAI_API_KEY="your-api-key-here"
```

## Usage

Run the script with:
```bash
python instances.py <domain_name> <start_instance> <end_instance> <setup_domain> [--optional_args]
```

Example:
```bash
python instances.py blocksworld 1 5 true --beam_width=5
```

This will:
- Process blocksworld domain
- Run instances 1-5
- Setup the domain first (true). Setting this to true translates the domain pddl file and acquires the initial diagram schema and conceptual diagram for the domain.
- Use a beam width of 5 for the search

## Structure
Each domain needs:
- A folder with domain name
- A domain.pddl file
- A PDDL_tranlation.py module
- An instances folder with problem files
